var _days = 'Days';
var _hours = 'Hours';
var _minutes = 'Minutes';
var _seconds = 'Seconds';
var _messageAfterCount = 'The event has Started!';

var $ = jQuery.noConflict();
$(document).ready(function($) {
    "use strict";

    if (location.hash) {
        window.scrollTo(0, 0);
        setTimeout(function() {
            window.scrollTo(0, 0);
        }, 1);
    }

//  Homepage Slider (Flex Slider)

    if ($('.flexslider').length > 0) {
        $('.flexslider').flexslider({
            controlNav: false,
            prevText: "",
            nextText: ""
        });
    }

//  Open tab from another page

    $('a[data-toggle="tab"]').on('show.bs.tab', function(e) {});

    $('#tabs a[href=' + location.hash +']').tab('show');

    $('.secondary-navigation li a').on('click',function (e) {
        $('#tabs a[href=' + this.hash +']').tab('show');
    });

//  Table Sorter
    if ($('.tablesorter').length > 0) {
        $(".course-list-table").tablesorter();
    }

//  Rating

    if ($('.rating-individual').length > 0) {
        $('.rating-individual').raty({
            path: 'assets/img',
            readOnly: true,
            score: function() {
                return $(this).attr('data-score');
            }
        });
    }

    if ($('.rating-user').length > 0) {
        $('.rating-user .inner').raty({
            path: 'assets/img',
            starOff : 'big-star-off.png',
            starOn  : 'big-star-on.png',
            width: 180,
            target : '#hint',
            targetType : 'number',
            targetFormat : 'Rating: {score}',
            click: function(score, evt) {
                alert("Your Rating: " + score + "\nThank You!");
            }
        });
    }

//  Checkbox styling

    if ($('.checkbox').length > 0) {
        $('input').iCheck();
    }

// Disable input on count down

    $('.knob').prop("disabled", true);


//  Count Down - Landing Page

    if ($('.count-down').length > 0) {
        $(".count-down").ccountdown(2014,12,24,'18:00');
    }

//  Selectize

    $('select').selectize();

//  Center Slide Vertically

    $('.flexslider').each(function () {
        var slideHeight = $(this).height();
        var contentHeight = $('.flexslider .slides li .slide-wrapper').height();
        var padTop = (slideHeight / 2) - (contentHeight / 2);
        $('.flexslider .slides li .slide-wrapper').css('padding-top', padTop);
    });

//  Slider height on small screens

    if (document.documentElement.clientWidth < 991) {
        $('#landing-page-head-image').css('height', $(window).height());
        $('.flexslider').css('height', $(window).height());
    }

//  Homepage Carousel

    $(".image-carousel").owlCarousel({
        items: 1,
        autoPlay: true,
        stopOnHover: true,
        navigation: true,
        navigationText : false,
        responsiveBaseWidth: ".image-carousel-slide"
        //responsiveBaseWidth: ".author"
    });

//  Smooth Scroll

    $('.navigation-wrapper .nav a[href^="#"], a[href^="#"].roll').on('click',function (e) {
        e.preventDefault();
        var target = this.hash,
            $target = $(target);
        $('html, body').stop().animate({
            'scrollTop': $target.offset().top
        }, 2000, 'swing', function () {
            window.location.hash = target;
        });
    });

//  Fixed Navigation After Scroll

//    if (document.documentElement.clientWidth > 768) {
//        $(window).scroll(function () {
//            if ($(window).scrollTop() > 50) {
//                $('.page-landing-page .primary-navigation-wrapper').addClass('navigation-fixed');
//            } else {
//                $('.page-landing-page .primary-navigation-wrapper').removeClass('navigation-fixed');
//            }
//        });
//    }


//  author Carousel (Owl Carousel)

    $(".author-carousel").owlCarousel({
        items: 1,
        autoPlay: false,
        stopOnHover: true,
        responsiveBaseWidth: ".author"
    });

//  Equal Rows

    if(document.documentElement.clientWidth > 991) {
        $('.row').equalHeights();
    }

    $( document.body ).on( 'click', '.dropdown-menu li', function( event ) {
        var $target = $( event.currentTarget );
        $target.closest( '.btn-group' )
            .find( '[data-bind="label"]' ).text( $target.text() )
            .end()
            .children( '.dropdown-toggle' ).dropdown( 'toggle' );
        return false;
    });

//  Slider Subscription Form

    $("#slider-submit").bind("click", function(event){
        $("#slider-form").validate({
            submitHandler: function() {
                $.post("slider-form.php", $("#slider-form").serialize(),  function(response) {
                    $('#form-status').html(response);
                    $('#submit').attr('disabled','true');
                });
                return false;
            }
        });
    });

//  Contact Form with validation

    $("#submit").bind("click", function(event){
        $("#contactform").validate({
            submitHandler: function() {
                $.post("contact.php", $("#contactform").serialize(),  function(response) {
                    $('#form-status').html(response);
                    $('#submit').attr('disabled','true');
                });
                return false;
            }
        });
    });

//  Landing Page Form

    $("#landing-page-submit").bind("click", function(event){
        $("#form-landing-page").validate({
            submitHandler: function() {
                $.post("landing-page-form.php", $("#form-landing-page").serialize(),  function(response) {
                    $('#form-status').html(response);
                    $('#submit').attr('disabled','true');
                });
                return false;
            }
        });
    });

//  Vanilla Box

    if ($('.image-popup').length > 0) {
        $('a.image-popup').vanillabox({
            animation: 'default',
            type: 'image',
            closeButton: true,
            repositionOnScroll: true
        });
    }

//  Calendar

    if ($('.calendar').length > 0) {
        $('.calendar').fullCalendar({
            firstDay: 1,
            weekMode: 'variable',
            contentHeight: 700,
            header: {
                right: 'month,basicWeek,basicDay prev,next'
            },

            events: "events.php"

        });
    }

//  Event title shorting

    $('.fc-view-month .fc-event-title').each(function(){
        $(this).text($(this).text().substring(0,25));
    });

//  PDF Viewer

    var $pdfObject = $('.pdf-object');
    if ($pdfObject.length > 0) {
        $pdfObject.media({width:'100%', height:420});
    }

});


// Remove button function for "join to course" button after count down is over

function disableJoin() {
    // Find "join to course" button
    var buttonToBeRemoved = document.getElementById("btn-course-join");
    // Find "join to course" button on bottom of course detail
    var buttonToBeRemovedBottom = document.getElementById("btn-course-join-bottom");
    // Remove button
    buttonToBeRemoved.remove();
    // Remove button on the bottom
    buttonToBeRemovedBottom.remove();
    // Give the ".course-count-down" element new class to hide date
    document.getElementById("course-count-down").className += " disable-join";
    document.getElementById("course-start").className += " disable-join";
}

//  Count Down - Course Detail

if (typeof _date != 'undefined') { // run function only if _date is defined
    var Countdown = new Countdown({
        dateEnd: new Date(_date),
        msgAfter: _messageAfterCount,
        onEnd: function() {
            disableJoin(); // Run this function after count down is over
        }
    });
}