<!DOCTYPE html>

<html lang="en-US">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="author" content="Abu Shquier">
    <meta name="description" content="Alumni, Jerash University, Abu Shquier, JPU, Association">

    <?php include 'includes_top.php'; ?>

    <title><?php echo $this->db->get_where('about_us', array('about_us_id' => '1'))->row()->title; ?> | <?php echo $this->lang->line($page_name); ?></title>

    <link href="<?php echo base_url(); ?>uploads/logos/<?php echo $this->db->get_where('setting', array('setting_id' => 7))->row()->content; ?>" rel="icon" type="image/*">
    <?php date_default_timezone_set($this->db->get_where('setting', array('setting_id' => 12))->row()->content); ?>
    <style>
        input[type="text"], input[type="email"], input[type="search"], input[type="password"], input[type="number"], textarea, select
      {  
    -moz-box-shadow: none;
    -webkit-box-shadow: none;
    box-shadow: none;
    -moz-border-radius: 0px;
    -webkit-border-radius: 0px;
    border-radius: 0px;
    -moz-transition: 0.3s;
    -o-transition: 0.3s;
    -webkit-transition: 0.3s;
    transition: 0.3s;
    background-color: whitesmoke;
    border: 2px solid #c5c5c5;
    font-size: 12px;
    min-height: 40px;
    padding: 10px 9px 9px 9px;
    width: 100%;
    }
    select
    {
            -webkit-writing-mode: horizontal-tb !important;
  
    text-rendering: auto;
    color: -internal-light-dark(black, white);
    letter-spacing: normal;
    word-spacing: normal;
    line-height: normal;
    text-transform: none;
    text-indent: 0px;
    text-shadow: none;
    display: inline-block;
    text-align: start;
    appearance: auto;
    box-sizing: border-box;
    align-items: center;
    white-space: pre;
    -webkit-rtl-ordering: logical;
    background-color: -internal-light-dark(rgb(255, 255, 255), rgb(59, 59, 59));
    cursor: default;
    margin: 0em;
    border-width: 1px;
    border-style: solid;
    border-color: -internal-light-dark(rgb(118, 118, 118), rgb(133, 133, 133));
    border-image: initial;
    border-radius: 0px;
}
    }
    </style>
</head>

<body class="<?php echo $body_class; ?> page-my-account">
    <!-- Wrapper -->
    <div class="wrapper">
        <!-- Header -->
        <div class="navigation-wrapper">
            <?php include 'header.php'; ?>
            <?php include 'navbar.php'; ?>
            <div class="background">
                <img src="<?php echo base_url(); ?>assets/alumni/img/background-city.png" alt="background">
            </div>
        </div>
        <!-- end Header -->
        <?php include 'modal.php'; ?>
        <!-- Page Content -->
        <?php include $page_name . '.php'; ?>
        <!-- end Page Content -->
        <div id="page-content">
    <!-- Slider -->
    <div id="homepage-carousel">
        <div class="container">
            <div class="homepage-carousel-wrapper">
                <div class="row">
                    <div class="col-md-6 col-sm-7">
                        <div class="image-carousel">
                            <?php
                            $slider_info = $this->security->xss_clean($this->db->get_where('slide', array('status' => 'Show'))->result_array());
                            foreach ($slider_info as $slide) :
                            ?>
                                <div class="image-carousel-slide">
                                    <img src="uploads/slides/<?php echo $slide['image_link']; ?>" alt="<?php echo $slide['image_name']; ?>">
                                </div>
                            <?php endforeach; ?>
                        </div><!-- /.slider-image -->
                    </div><!-- /.col-md-6 -->
                    <div class="col-md-6 col-sm-5">
                        <div class="slider-content">
                            <div class="row">
                                <div class="col-md-12">
                                    <h1><?php echo $this->lang->line('add_volunteer_header'); ?></h1>
                                     <?php echo form_open('register/alumnus', array('method' => 'post')); ?>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="input-group">
                                                <input class="form-control has-dark-background" name="name" placeholder="<?php echo $this->lang->line('name'); ?>" type="text" required>
                                            </div>
                                        </div><!-- /.col-md-6 -->
                                        <div class="col-md-6">
                                            <div class="input-group">
                                                <input class="form-control has-dark-background" name="email" id="slider-email" placeholder="<?php echo $this->lang->line('email'); ?>" type="email" required>
                                            </div>
                                        </div><!-- /.col-md-6 -->
                                    </div><!-- /.row -->
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="input-group">
                                                <select class="form-control has-dark-background" name="batch" id="slider-study-level" required>
                                                    <option value=""><?php echo $this->lang->line('class'); ?></option>
                                                    <?php for ($start_year = date('Y'); $start_year >= 1900; $start_year--) : ?>
                                                        <option value="<?php echo $start_year; ?>"><?php echo $start_year; ?></option>
                                                    <?php endfor; ?>
                                                </select>
                                            </div><!-- /.form-group -->
                                        </div><!-- /.col-md-6 -->
                                        <div class="col-md-6">
                                            <div class="input-group">
                                                <select class="form-control has-dark-background" name="profession_id" id="slider-course" required>
                                                    <option value=""><?php echo $this->lang->line('profession'); ?></option>
                                                    <?php
                                                    $professions_info = $this->security->xss_clean($this->db->get('profession')->result_array());
                                                    foreach ($professions_info as $profession) :
                                                    ?>
                                                        <option value="<?php echo $profession['profession_id']; ?>"><?php echo $profession['name']; ?></option>
                                                    <?php endforeach; ?>
                                                </select>
                                            </div><!-- /.form-group -->
                                        </div><!-- /.col-md-6 -->
                                        
              <div class="col-md-6">
               <div class="input-group">
                <select title="Select Level" name="regcountry" class="form-control has-dark-background" id="country-name">      
                    <option value="">اختر المرحلة</option>
                    <?php
                    foreach ($geCountries as $key => $element) {
                        echo '<option value="'.$element['country_id'].'">'.$element['country_name'].'</option>';
                    }
                    ?>
                </select>
            </div>
            </div>
             <div class="col-md-6">
               <div class="input-group">
                     <select title="Select Fac" name="state_name" class="form-control has-dark-background" id="state-name">      
                    <option value="">اختر الكليّة</option>
                </select> 
            </div>
            </div>
                         <div class="col-md-6">
               <div class="input-group">
                     <select title="Select Fac" name="state_name" class="form-control has-dark-background" id="city-name">      
                    <option value="">اختر التخصّص</option>
                </select> 
            </div>
            </div>
                                   
                                    </div><!-- /.row -->
                                    <button type="submit" class="btn btn-framed pull-right"><?php echo $this->lang->line('submit'); ?></button>
                                    <div id="form-status"></div>
                                    <?php echo form_close(); ?>
                                </div><!-- /.col-md-12 -->
                            </div><!-- /.row -->
                        </div><!-- /.slider-content -->
                    </div><!-- /.col-md-6 -->
                </div><!-- /.row -->
                <div class="background"></div>
            </div><!-- /.slider-wrapper -->
            <div class="slider-inner"></div>
        </div><!-- /.container -->
    </div>
    <!-- end Slider -->

    <!-- News, Events, About -->
    <div class="block">
        <div class="container">
            <div class="row">
                <div class="col-md-4 col-sm-6">
                    <section class="news-small" id="news-small">
                        <header>
                            <h2><?php echo $this->lang->line('stories'); ?></h2>
                        </header>
                        <div class="section-content">
                            <?php
                            $this->db->order_by('timestamp', 'desc');
                            $this->db->limit(3);
                            $stories = $this->security->xss_clean($this->db->get('story')->result_array());
                            foreach ($stories as $story) :
                            ?>
                                <article>
                                    <figure class="date">
                                        <i class="fa fa-calendar"></i> <?php echo date('m-d-Y', $story['timestamp']); ?>
                                    </figure>
                                    <header>
                                        <a href="<?php echo base_url(); ?>story/<?php echo $story['permalink']; ?>"><?php echo $story['title'] ?></a>
                                    </header>
                                </article>
                            <?php endforeach; ?>
                        </div><!-- /.section-content -->
                        <!-- <a href="index.html" class="read-more stick-to-bottom">All News</a> -->
                    </section><!-- /.news-small -->
                </div><!-- /.col-md-4 -->
                <div class="col-md-4 col-sm-6">
                    <section class="events small" id="events-small">
                        <header>
                            <h2><?php echo $this->lang->line('events'); ?></h2>
                            <!-- <a href="index.html" class="link-calendar">Calendar</a> -->
                        </header>
                        <div class="section-content">
                            <?php
                            $this->db->order_by('timestamp', 'desc');
                            $this->db->limit(3);
                            $events = $this->security->xss_clean($this->db->get('event')->result_array());
                            foreach ($events as $event) :
                            ?>
                                <article class="event nearest">
                                    <figure class="date">
                                        <div class="month"><?php echo date('M', $event['event_date']); ?></div>
                                        <div class="day"><?php echo date('d', $event['event_date']); ?></div>
                                    </figure>
                                    <aside>
                                        <header>
                                            <a href="<?php echo base_url(); ?>event/<?php echo $event['permalink']; ?>">
                                                <?php echo $event['name']; ?>
                                            </a>
                                        </header>
                                        <div class="additional-info">#<?php echo $event['hashtag']; ?></div>
                                    </aside>
                                </article>
                            <?php endforeach; ?>
                        </div><!-- /.section-content -->
                    </section><!-- /.events-small -->
                </div><!-- /.col-md-4 -->
                <div class="col-md-4 col-sm-12">
                    <section id="about">
                        <header>
                            <h2><?php echo $this->lang->line('about'); ?> <?php echo $this->db->get_where('about_us', array('about_us_id' => '1'))->row()->title; ?></h2>
                        </header>
                        <div class="section-content">
                            <img src="uploads/about_us/<?php echo $this->db->get_where('about_us', array('about_us_id' => '1'))->row()->image_link; ?>" alt="" class="add-margin">
                            <p><?php echo $this->db->get_where('about_us', array('about_us_id' => '1'))->row()->description; ?></p>
                        </div><!-- /.section-content -->
                    </section><!-- /.about -->
                </div><!-- /.col-md-4 -->
            </div><!-- /.row -->
        </div><!-- /.container -->
    </div>
    <!-- end News, Events, About -->

    <!-- Our Professors, Gallery -->
    <div class="block">
        <div class="container">
            <div class="row">
                <div class="col-md-4 col-sm-4">
                    <section id="our-professors">
                        <header>
                            <h2><?php echo $this->lang->line('our_alumni'); ?></h2>
                        </header>
                        <div class="section-content">
                            <div class="professors">
                                <?php
                                $this->db->order_by('timestamp', 'desc');
                                $this->db->limit(2);
                                $alumni = $this->security->xss_clean($this->db->get_where('alumnus', array('status' => 1))->result_array());
                                foreach ($alumni as $alumnus) :
                                ?>
                                    <article class="professor-thumbnail">
                                        <figure class="professor-image">
                                            <a href="<?php echo base_url(); ?>alumnus/<?php echo $alumnus['username']; ?>">
                                                <?php if ($alumnus['image_link']) : ?>
                                                    <img style="width: 80px !important" src="<?php echo base_url(); ?>uploads/alumni/<?php echo $alumnus['image_link']; ?>" alt="">
                                                <?php else : ?>
                                                    <img style="width: 80px !important" src="<?php echo base_url(); ?>assets/dummy.png" alt="">
                                                <?php endif; ?>
                                            </a>
                                        </figure>
                                        <aside>
                                            <header>
                                                <a href="<?php echo base_url(); ?>alumnus/<?php echo $alumnus['username']; ?>">
                                                    <?php echo $alumnus['name']; ?>
                                                </a>
                                                <div class="divider"></div>
                                                <figure class="professor-description"><?php echo $alumnus['position']; ?></figure>
                                            </header>
                                            <a href="<?php echo base_url(); ?>alumnus/<?php echo $alumnus['username']; ?>" class="show-profile">
                                                Show Profile
                                            </a>
                                        </aside>
                                    </article>
                                <?php endforeach; ?>
                            </div><!-- /.professors -->
                        </div><!-- /.section-content -->
                    </section><!-- /.our-professors -->
                </div><!-- /.col-md-4 -->

                <div class="col-md-8 col-sm-8">
                    <section id="gallery">
                        <header>
                            <h2><?php echo $this->lang->line('gallery'); ?></h2>
                        </header>
                        <div class="section-content">
                            <ul class="gallery-list">
                                <?php
                                $this->db->order_by('timestamp', 'desc');
                                $this->db->limit(14);
                                $images = $this->security->xss_clean($this->db->get('gallery')->result_array());
                                foreach ($images as $image) :
                                ?>
                                    <li>
                                        <a href="<?php echo base_url(); ?>uploads/gallery/<?php echo $image['image_link']; ?>" class="image-popup">
                                            <img src="<?php echo base_url(); ?>uploads/gallery/<?php echo 'thumb_' . $image['image_link']; ?>" alt="">
                                        </a>
                                    </li>
                                <?php endforeach; ?>
                            </ul>
                        </div><!-- /.section-content -->
                    </section><!-- /.gallery -->
                </div><!-- /.col-md-4 -->

            </div><!-- /.row -->
        </div><!-- /.container -->
    </div>
    <!-- end Our Professors, Gallery -->
</div>
<?php
$this->load->view('templates/footer');
//$this->load->view('alumni/index');

//include 'templates/footer.php';
?>
<body class="<?php echo $body_class; ?> page-my-account">
    <!-- Wrapper -->
    <div class="wrapper">
        <!-- Header -->
        
      
        
        <?php include 'footer.php'; ?>
    </div>
    <!-- end Wrapper -->
    <?php include 'includes_bottom_menu.php'; ?>


    <script type="text/javascript">
        $(document).ready(function() {
            window.setTimeout(function() {
                $(".alert").slideUp(1000, function() {
                    $(this).remove();
                });
            }, 5000);
        });
    </script>
    
</body>

</html>

