<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Microvisor\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class AccountSecretContext extends InstanceContext {
    /**
     * Initialize the AccountSecretContext
     *
     * @param Version $version Version that contains the resource
     * @param string $key The secret key.
     */
    public function __construct(Version $version, $key) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['key' => $key, ];

        $this->uri = '/Secrets/' . \rawurlencode($key) . '';
    }

    /**
     * Fetch the AccountSecretInstance
     *
     * @return AccountSecretInstance Fetched AccountSecretInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): AccountSecretInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new AccountSecretInstance($this->version, $payload, $this->solution['key']);
    }

    /**
     * Delete the AccountSecretInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Microvisor.V1.AccountSecretContext ' . \implode(' ', $context) . ']';
    }
}