<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Microvisor\V1;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class AccountConfigContext extends InstanceContext {
    /**
     * Initialize the AccountConfigContext
     *
     * @param Version $version Version that contains the resource
     * @param string $key The config key.
     */
    public function __construct(Version $version, $key) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['key' => $key, ];

        $this->uri = '/Configs/' . \rawurlencode($key) . '';
    }

    /**
     * Fetch the AccountConfigInstance
     *
     * @return AccountConfigInstance Fetched AccountConfigInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): AccountConfigInstance {
        $payload = $this->version->fetch('GET', $this->uri);

        return new AccountConfigInstance($this->version, $payload, $this->solution['key']);
    }

    /**
     * Delete the AccountConfigInstance
     *
     * @return bool True if delete succeeds, false otherwise
     * @throws TwilioException When an HTTP error occurs.
     */
    public function delete(): bool {
        return $this->version->delete('DELETE', $this->uri);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Microvisor.V1.AccountConfigContext ' . \implode(' ', $context) . ']';
    }
}