﻿@extends('site.layouts.site')
@section('content')
<link href="{{ dsAsset('site/css/custom/website-booking.css') }}" rel="stylesheet" />
<script src="{{ dsAsset('site/js/custom/website-booking.js') }}"></script>

<!--start banner section -->
<section class="banner-area position-relative" style="background:url({{$appearance->background_image}}) no-repeat;">
    <div class="overlay overlay-bg"></div>
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <div class="position-relative text-center">
                    <h1 class="text-capitalize mb-3 text-white">{{translate('Appointment Booking')}}</h1>
                    <a class="text-white" href="{{route('site.home')}}">{{translate('Home')}} </a>
                    <i class="icofont-long-arrow-right text-white"></i>
                    <a class="text-white" href="{{route('site.appoinment.booking')}}"> {{translate('Appointment Booking')}}</a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- end banner section -->

<!-- Start booking Area -->
<section class="appoinment-booking-area mb-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 order-sm-first order-last">
                <div class="single-booking-area single-booking-support mb-3">
                    <div class="mt-3">
                        <div class="support-man-icon mb-3">
                            <i class="icofont-support text-lg"></i>
                        </div>
                        <span class="h3">{{translate('Call for any Emergency Support!')}}</span>
                        <h2 class="text-color mt-3">{{$appearance->contact_phone}}</h2>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 mb-3">
                <div class="single-booking-area">
                    <form class="form-wrap" id="formServiceBooking">
                        <div id="serviceStep">
                            <h3>{{translate('Service')}}</h3>
                            <section>
                                <div class="row">
                                    <div class="col-md-3">
                                        <label for="cmn_branch_id" class="text-center">{{translate('Branch')}}</label>
                                        <select id="cmn_branch_id" name="cmn_branch_id" class="serviceInput form-control">

                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="sch_service_category_id" class="text-center">{{translate('Category')}}</label>
                                        <select id="sch_service_category_id" name="sch_service_category_id" class="serviceInput form-control">

                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="sch_service_id" class="text-center">{{translate('Service')}}</label>
                                        <select id="sch_service_id" name="sch_service_id" class="serviceInput form-control">

                                        </select>
                                    </div>
                                    <div class="col-md-3">
                                        <label for="sch_employee_id" class="text-center">{{translate('Staff')}}</label>
                                        <select id="sch_employee_id" name="sch_employee_id" class="serviceInput form-control">
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-auto col-lg-auto col-sm-auto" id="divServiceCalendar">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <label for="serviceDate" class="text-center">{{translate('Service Date')}}</label>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-12">
                                                <input id="serviceDate" name="service_date" class="form-control input-sm" type="text" readonly />
                                                <div id="divServiceDate" style="float: left;"></div>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="col">
                                        <div id="divTopDays">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="float-start" id="divDaysName"></div>
                                                    <div class="float-end" id="divPreNext">
                                                        <i id="iPrvDate" title="Previous day" class="iChangeDate fa fa-chevron-left float-start"></i>
                                                        <i id="iNextDate" title="Next day" class="iChangeDate fa fa-chevron-right float-end"></i>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row divServiceAvaiable">
                                                <div class="col-md-12" id="divServiceAvaiableTime">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col divSelectedService">
                                        <i class="fa fa-calendar float-start pl-2 mt-1 mr-1" aria-hidden="true"></i>
                                        <i id="iSelectedServiceText" class=""></i>
                                    </div>
                                    <div class="col-md-auto col-lg-auto col-sm-auto float-end">
                                        <button type="button" class="btn btn-success float-end" id="add-service-btn"><i class="fas fa-plus-circle"></i> {{translate('Add more service')}}</button>
                                    </div>
                                    <div class="col-md-12 mt-3">
                                        <table id="tbl-service-cart" class="table table-responsive table-bordered fs-13 text-start d-none">
                                            <thead>
                                                <tr>
                                                    <th class="text-center">{{translate('SL')}}</th>
                                                    <th class="text-center">{{translate('Service')}}</th>
                                                    <th class="text-center">{{translate('Staff')}}</th>
                                                    <th class="text-right">{{translate('Date')}}</th>
                                                    <th class="text-center">{{translate('Time')}}</th>
                                                    <th class="text-center">{{translate('Fee')}}</th>
                                                    <th class="text-center">{{translate('Opt')}}</th>
                                                </tr>
                                            </thead>
                                            <tbody class="text-start" id="iSelectedServiceList"></tbody>
                                        </table>
                                    </div>
                                </div>
                            </section>
                            <h3>{{translate('Details')}} </h3>
                            <section>
                                <div class="row p-1">
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <label for="full_name" class="text-center">{{translate('Full Name')}} *</label>
                                                <input type="text" id="full_name" name="full_name" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="email" class="text-center">{{translate('Email')}} *</label>
                                                <input type="email" id="email" name="email" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="phone_no" class="text-center">{{translate('Phone')}} *</label>
                                                <input type="tel" id="phone_no" name="phone_no" class="form-control" />
                                            </div>
                                        </div>
                                    </div>
                                    <!--
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <label for="state" class="text-center">{{translate('State')}}</label>
                                                <input type="text" id="state" name="state" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="city" class="text-center">{{translate('City')}}</label>
                                                <input type="text" id="city" name="city" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="postal_code" class="text-center">{{translate('Postal Code')}}</label>
                                                <input type="text" id="postal_code" name="postal_code" class="form-control" />
                                            </div>
                                        </div>
                                    </div>
                                    -->
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <label for="dept" class="text-center">{{translate('Dept')}}</label>
                                                <input type="text" id="dept" name="dept" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="course_name" class="text-center">{{translate('Course Name')}}</label>
                                                <input type="text" id="course_name" name="course_name" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="course_id" class="text-center">{{translate('Course ID')}}</label>
                                                <input type="text" id="course_id" name="course_id" class="form-control" />
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <label for="section" class="text-center">{{translate('Section')}}</label>
                                                <input type="text" id="section" name="section" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="lecturer" class="text-center">{{translate('Lecturer Name')}}</label>
                                                <input type="text" id="lecturer" name="lecturer" class="form-control" />
                                            </div>
                                            <div class="col-md-4">
                                                <label for="stu_total" class="text-center">{{translate('Student Total')}}</label>
                                                <input type="text" id="stu_total" name="stu_total" class="form-control" />
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="row">
                                        <div class="col-md-6">
                                                <label for="invigilator" class="text-center">{{translate('Invigilator')}}</label>
                                                <textarea id="invigilator" name="invigilator" class="form-control" > </textarea>
                                            </div>
                                            <!--
                                            <div class="col-md-4">
                                                <label for="street_address" class="text-center">{{translate('Street Address')}}</label>
                                                <input type="text" id="street_address" name="street_address" class="form-control" />
                                            </div>
                                            -->
                                            <div class="col-md-6">
                                                <label for="service_remarks" class="text-center">{{translate('Service Remarks')}}</label>
                                                <input type="text" id="service_remarks" name="service_remarks" class="form-control" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </section>

                            
                            <h3>بيانات (غير هامّة)</h3>
                            <section>

                                <div class="row mt-3" id="divPaymentType">
                                    <div class="col-md-5 mb-4">
                                        <h6 class="float-start">Choose a way to pay</h6>
                                        <div id="divPaymentMethod" class="w100 float-start">

                                        </div>
                                    </div>
                                    <div class="col-md-7">
                                        <div class="w-100 float-start" id="divOrderSummary">
                                            <h5 class="text-start">{{translate('Order Summary')}}</h5>
                                            <div class="w-100 float-start">
                                                <div id="divServiceSection" class="w-100 float-start">
                                                    <!-- service list will append here-->

                                                </div>

                                                <div class="service-item">
                                                    <div class="float-start">Subtotal</div>
                                                    <div class="float-end fw-bold" id="summary-subtotal">0</div>

                                                </div>
                                                <div class="service-item" id="summary-discount-parent">
                                                    <div class="float-start">Discount</div>
                                                    <div class="float-end fw-bold" id="summary-discount">0</div>
                                                </div>
                                                <div class="service-item">
                                                    <div class="float-start w-100 text-start">Apply Coupon Code</div>
                                                    <div class="float-start w-100">
                                                        <div class="input-group mb-3">
                                                            <input type="text" name="coupon_code" id="coupon_code" class="form-control" aria-describedby="btn-apply-coupon">
                                                            <button class="btn btn-booking" type="button" id="btn-apply-coupon">Apply Coupon</button>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="service-item">
                                                    <div class="service-border-button"></div>
                                                    <div class="float-start fw-bold">Total Amount</div>
                                                    <div class="float-end fw-bold" id="summary-total">0</div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </section>
                            <h3>اكتمل التسجيل بنحاح</h3>
                            <section>
                                <div class="color-success p-5">{{translate('Your service booking is completed & service is under processing, Check your email.')}}</div>
                            </section>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- End booking Area -->

@endsection
